__PURE_controller_version = 1.25
ac.debug(">>> Pure Controller",string.format('v%.2f', __PURE_controller_version))

-- 0 = dynamic
-- 1 = static, career/championship
__PURE__controller_type = __PURE__controller_type or 0

__pure_ctrl__path = "extension\\weather-controllers\\pureCtrl\\"
__pure_path = __pure_ctrl__path.."\\..\\..\\weather\\pure"
__pure_planner_path = "apps\\lua\\PurePlanner\\"
__Planner_Settings_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\PurePlanner\\"
__Planner_Settings_WeatherPresets_path = __Planner_Settings_path.."WeatherPresets\\"
__Planner_Settings_Plans_path = __Planner_Settings_path.."Plans\\"

function _d(v)
    ac.debug("---",v)
    return v
end

__CSP_version = 0
if ac['getPatchVersionCode'] ~= nil then __CSP_version = ac.getPatchVersionCode() end


--dofile (__pure_path.."\\utils\\utils_memory_backup.lua")
--dofile (__pure_path.."\\utils\\utils_lua.lua")
-- fast Lookup tables
dofile (__pure_path.."\\utils\\utils_LUT.lua")
dofile (__pure_path.."\\utils\\utils_basics.lua")
-- fast communikation via ac.connect
dofile (__pure_path.."\\utils\\utils_connect.lua") -- also needed for TYPES
-- a library to send states via ac.connect
dofile (__pure_path.."\\utils\\utils_state.lua")
dofile (__pure_path.."\\utils\\utils_json.lua")
dofile (__pure_ctrl__path.."\\CM-Drive.lua")




-- State connection from Pure Planner app, to receive the data from Pure Planner app
__PURE_CTRL__STATE = PureState:new(nil, true, "PurePlanner_Controller")













-- basic controller, uses selected weather ID to get weather type
local start_time = os.clock()


weatherType = ac.getInputWeatherType()    -- if weather doesn’t have type set, value will be guessed based on weather ID
if weatherType > 28 and weatherType < 31 then
	weatherType = 15 -- use Clear is failsafe weather
end


temperatures = ac.getInputTemperatures()  -- { ambient = 23, road = 15 }
windParams = ac.getInputWind()            -- { direction = 300, speedFrom = 10, speedTo = 15 }
trackState = ac.getInputTrackState()      -- { sessionStart = 95, sessionTransfer = 90, randomness = 2, lapGain = 132 }
startingDate = ac.getInputDate()          -- seconds from 1970 etc.

trackCoordinates = ac.getTrackCoordinates()  -- { x = longitude, y = latitude }
timeZoneOffset = ac.getTimeZoneOffset()      -- { base = -25200, dst = 0 }


if __PURE__controller_type<1 then
	-- reset the road temp, because it comes wrong from CM if a dynamic controller is selected
	temperatures.road = temperatures.ambient * 1.4
end

local result = ac.ConditionsSet()
result.currentType = weatherType
result.upcomingType = weatherType
result.transition = 0.0
result.humidity = 0.0
result.variableA = 0.0	-- mist
result.variableB = 0.0	-- ground fog???
result.variableC = 2.3 --controller version
result.temperatures.road = temperatures.road
result.temperatures.ambient = temperatures.ambient
result.wind.direction = windParams.direction
result.wind.speedFrom = windParams.speedFrom
result.wind.speedTo = windParams.speedTo
result.trackState = trackState
ac.setConditionsSet(result)






local _l_dry = { 15, 16, 17, 18, 19, 21, 23, 25, 31 }
local _l_wet = { 3, 4, 5, 6, 7, 26 }
local _l_bad = { 2, 5, 8, 11, 14, 20, 27, 28 }
local function get_random_from_list(list)
	if list~=nil and #list>0 then
		local tmp = #list
		math.randomseed(os.clock())
		tmp = math.floor(math.random()*tmp) + 1
		return list[tmp]
	end
	return -1
end


local cfg = nil

if __CSP_version >= 2363 then --0.1.80p218
	if __PURE__controller_type < 1 then
		cfg = PURE_CM_DRIVE__readSettings()
	end
else

end











local rain_preset = false
local function init_controller()

	local config = nil

	if __CSP_version < 2349 then -- 0.1.80p204
		config = ac.INIConfig.load(ac.getFolder(ac.FolderID.Cfg)..'\\race.ini', ac.INIFormat.Default)
	else
		config = ac.INIConfig.raceConfig()
	end

	if config ~= nil then
		local weather_name = config:get('WEATHER', 'NAME', '')
		if weather_name ~= '' then
			local weather = ac.INIConfig.load(ac.getFolder(ac.FolderID.Root)..'\\content\\weather\\'..weather_name..'\\weather.ini', ac.INIFormat.Default)
			if weather ~= nil then

				local found = false
				for tmp in pairs(weather.sections) do
					if tmp=="RAINFX" then
						found = true
						break
					end
				end

				if found then
					result.rainIntensity 	= weather:get('RAINFX', 'INTENSITY', 0.0)
					result.rainWetness 		= weather:get('RAINFX', 'WETNESS', 0.0)
					result.rainWater 		= weather:get('RAINFX', 'WATER', 0.0)
					rain_preset = true
				end
			end
		end
	end
end
init_controller()








dofile(__pure_planner_path.."\\settings\\settings_defaults.lua")


local function set_weather_data(weather)

	local index = weather.index or 100

	if index~= 50 then -- CM weather
		result.rainIntensity = __SETTINGS__weather_presets_index[index][3]
		result.rainWetness 	 = __SETTINGS__weather_presets_index[index][6]
		result.rainWater 	 = __SETTINGS__weather_presets_index[index][7]
	end

	if not weather.rain_amount_dyn then
		result.rainIntensity = weather.rain_amount
	end
	if not weather.rain_wetness_dyn then
		result.rainWetness = weather.rain_wetness
	end
	if not weather.rain_water_dyn then
		result.rainWater = weather.rain_water
	end
end

local function Controller__load_any_plan(file)

    if file_exists(file) then
        local load_type = nil
        local buffer = io.load(file, nil)
        if buffer then
            local tmp = json.decode(buffer)
            if tmp and tmp.control then
                load_type = tmp.control.type
    
                -- activate the default daycycle as first running plan!
                local succes = false
                if load_type~=nil then
                    if load_type==1 then -- Daycycle
                        succes = true
                    elseif 	load_type==2 or -- Timed
							load_type==3 or -- Stamp
							load_type==4 then -- Live
                            
                        if tmp.container~=nil then
							local container = tmp.container[1]
							if container and container.data and container.data.weather then
								set_weather_data(container.data.weather)
							end
						end
						succes = true
                    end
                    if not succes then
                        ac.debug("plan load", "Could not load plan "..file.." !")
                    end
                else
                    ac.debug("plan load", "Plan type unknown!")
                end
            else
                ac.debug("plan load", "Could not decode plan!")
            end
        else
            ac.debug("plan load", "Could not open file "..file.." !")
        end
    else
        ac.debug("plan load", "File does not exist: "..file.." !")
    end
end



-- get a possible weather type from the CM menu
local wid = 0
if __PURE__controller_type < 1 then
	wid = PURE_CM_DRIVE__getWeatherRealId(cfg.CM_WEATHER)
else
	wid = weatherType
end

-- get the id if random is chosen
if wid == 40 then
	wid = get_random_from_list(_l_dry)
elseif wid == 41 then
	wid = get_random_from_list(_l_wet)
elseif wid == 42 then
	wid = get_random_from_list(_l_bad)
elseif wid == 43 then
	math.randomseed(os.clock())
	repeat
		wid = math.floor(math.random()*30) + 1
	until wid~=29 and wid~=30 -- not used in Pure Planner
end



local function preset_rain()

	if __PURE__controller_type < 1 then
		if cfg~=nil then

			if wid == 44 then
				-- predefined
				wid = result.currentType
			end
			result.rainIntensity = __SETTINGS__weather_presets_index[wid][3]
			result.rainWetness 	 = __SETTINGS__weather_presets_index[wid][6]
			result.rainWater 	 = __SETTINGS__weather_presets_index[wid][7]


			if cfg.LIVE>0 then
				
			else
				if cfg.LAST_USED>0 then
					
				else
					local plan_location = cfg.PLAN
					if plan_location~=nil and plan_location~="" then
						if string.sub(plan_location, #plan_location-4, #plan_location)==".json" then
							plan_location = string.sub(1, #plan_location-5)
						end
						local file = __Planner_Settings_Plans_path..plan_location..".json"

						Controller__load_any_plan(file)
					else
						
					end
				end
			end

			

			

			local tmp = cfg.START_WETNESS
			if tmp>1 then
				if tmp<3 then -- none
					result.rainWetness = 0
				elseif tmp<4 then -- low
					result.rainWetness = 0.015
				elseif tmp<5 then -- wet
					result.rainWetness = 0.05
				elseif tmp<6 then -- slippery
					result.rainWetness = 0.15
				elseif tmp<7 then -- under water
					result.rainWetness = 0.5
				end
			end

			tmp = cfg.START_PUDDLES
			if tmp>1 then
				if tmp<3 then -- none
					result.rainWater = 0
				elseif tmp<4 then -- some
					result.rainWater = 0.25
				elseif tmp<5 then -- more
					result.rainWater = 0.50
				elseif tmp<6 then -- full
					result.rainWater = 1.00
				end
			end
		end
	else

		result.rainIntensity = __SETTINGS__weather_presets_index[result.currentType][3]
		result.rainWetness 	 = __SETTINGS__weather_presets_index[result.currentType][6]
		result.rainWater 	 = __SETTINGS__weather_presets_index[result.currentType][7]
	end

	
	--ac.debug("####1", result.rainIntensity)
	--ac.debug("####2", result.rainWetness)
	--ac.debug("####3", result.rainWater)
end
if not rain_preset then preset_rain() end




local function lag(org, new, lagMult)
	return org + (new - org) * lagMult
end



local _l_debug_memory = false
local _l_tmp_wetness = 0.0
function update(dt)

	if __PURE_CTRL__STATE:checkInterface() then
		-- the state object was reconnected

		__PURE_CTRL__STATE:setValue("PureCtrl.restarted", true)
		__PURE_CTRL__STATE:setValue("ctrl.type", __PURE__controller_type)

		local acsim = ac.getSim()
		local timemulti = acsim~=nil and acsim.timeMultiplier or 1
		--ac.debug("###", acsim.timeMultiplier)
		__PURE_CTRL__STATE:setValue("CM.initDateTime.timemulti", timemulti)

		-- set the CM weather variables, so Pure Planner knows it
		__PURE_CTRL__STATE:setValue("CM.initWeather.temperatures.air", temperatures.ambient)
		__PURE_CTRL__STATE:setValue("CM.initWeather.temperatures.road", temperatures.road)
		__PURE_CTRL__STATE:setValue("CM.initWeather.wind.direction", windParams.direction)
		__PURE_CTRL__STATE:setValue("CM.initWeather.wind.speed", math.lerp(windParams.speedFrom, windParams.speedTo, 0.5))
		__PURE_CTRL__STATE:setValue("CM.initWeather.weatherID", weatherType)

		if cfg~=nil then
			if cfg.LIVE>0 then
				__PURE_CTRL__STATE:setString("PURE.initPlan", "live")
			else
				if cfg.LAST_USED>0 then
					__PURE_CTRL__STATE:setString("PURE.initPlan", "last_used")
				else
					if cfg.PLAN~=nil and cfg.PLAN~="" then
						__PURE_CTRL__STATE:setString("PURE.initPlan", cfg.PLAN)
					else
						__PURE_CTRL__STATE:setString("PURE.initPlan", "")
					end
				end
			end

			__PURE_CTRL__STATE:setValue("PURE.autostartPlan", cfg.AUTOSTART>0 and true or false)

			if wid == 44 then
				--predefined
			else
				-- random
				__PURE_CTRL__STATE:setValue("CM.initWeather.weatherID", wid)
			end
			__PURE_CTRL__STATE:setValue("CM.initWeather.wetness", cfg.START_WETNESS)
			__PURE_CTRL__STATE:setValue("CM.initWeather.water", cfg.START_PUDDLES)
		end

		__PURE_CTRL__STATE:setValue("PureCtrl.running", true)
	end

	if __PURE_CTRL__STATE:isConnected() then

		local lagMult = math.lagMult(0.95, dt)
		
		-- the controller version (3.0 or higher for Pure)
		result.variableC 		= __PURE_CTRL__STATE:getValue("ctrl.version") or 0
		
		result.currentType 		= __PURE_CTRL__STATE:getValue("weather.current") or result.currentType
		result.upcomingType 	= __PURE_CTRL__STATE:getValue("weather.next") or result.upcomingType
		result.transition 		= __PURE_CTRL__STATE:getValue("weather.transition") or 0.0

		result.humidity 		= lag(result.humidity, __PURE_CTRL__STATE:getValue("weather.humidity")		or 0.4, lagMult)
		result.variableA 		= lag(result.variableA, __PURE_CTRL__STATE:getValue("weather.mist")			or 0.0, lagMult)
		
		result.rainIntensity	= lag(result.rainIntensity, __PURE_CTRL__STATE:getValue("weather.rain.intensity") or 0.0, lagMult)
		if result.rainIntensity<0.00015 then result.rainIntensity = 0.0 end

		local new_wetness 		= (__PURE_CTRL__STATE:getValue("weather.rain.wetness") 	or 0.0)
		result.rainWetness		= lag(result.rainWetness, new_wetness * math.lerpInvSat(new_wetness, 0.00015, 0.001), lagMult)
		if result.rainWetness<0.00015 then result.rainWetness = 0.0 end

		result.rainWater		= lag(result.rainWater, __PURE_CTRL__STATE:getValue("weather.rain.water") 	or 0.0, lagMult)
		if result.rainWater<0.00015 then result.rainWater = 0.0 end

		result.wind.direction	= __PURE_CTRL__STATE:getValue("weather.wind.direction") or 0.0
		result.wind.speedFrom	= lag(result.wind.speedFrom, __PURE_CTRL__STATE:getValue("weather.wind.strength") 	or 0.0, lagMult)
		result.wind.speedTo		= lag(result.wind.speedTo, result.wind.speedFrom + result.wind.speedFrom * 0.25, lagMult)
	
		result.temperatures.road 	= lag(result.temperatures.road, __PURE_CTRL__STATE:getValue("weather.temp.road") 		or temperatures.road, lagMult)
		result.temperatures.ambient = lag(result.temperatures.ambient, __PURE_CTRL__STATE:getValue("weather.temp.ambient") 	or temperatures.ambient, lagMult)

		--ac.debug("#", result.currentType..", "..result.upcomingType..", "..result.transition)

		--ac.debug("##", string.format("intensity: %.3f, wetness: %.3f, water: %.3f", result.rainIntensity, result.rainWetness, result.rainWater))
	end

	ac.setConditionsSet2(result)

	if _l_debug_memory then
		runGC()
		printGC()
	end
end